/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.content.block.plant.PlantJsonGen;
import dev.xkmc.youkaishomecoming.content.block.plant.WildVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.YHCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.BaseCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.BranchCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.CenterCropVineBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.DoubleRopeCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.GrapeCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.VineFruitBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.VineTrunkBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeLoggedCropBlock;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.food.YHCrops;
import dev.xkmc.youkaishomecoming.util.VoxelBuilder;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;

public class GrapeVineSet {
    private static final int FRUIT_CHANCE = 5;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)9);
    public static final IntegerProperty FRUIT_AGE = IntegerProperty.m_61631_((String)"age", (int)5, (int)9);
    public final YHCrops crop;
    public final BlockEntry<GrapeTrunk> trunk;
    public final BlockEntry<GrapeVine> center;
    public final BlockEntry<GrapeBranch> side;
    public final BlockEntry<GrapeFruit> hanging;

    public GrapeVineSet(YHCrops crop) {
        this.crop = crop;
        String name = crop.getName();
        this.trunk = YoukaisHomecoming.REGISTRATE.block(name + "_trunk", p -> new GrapeTrunk((BlockBehaviour.Properties)p, crop::getSeed)).properties(p -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60978_(1.0f).m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY)).blockstate(this::buildTrunkModel).loot(this::buildTrunkLoot).tag(new TagKey[]{BlockTags.f_13082_}).register();
        this.center = YoukaisHomecoming.REGISTRATE.block(name + "_vines", x$0 -> new GrapeVine((BlockBehaviour.Properties)x$0)).initialProperties(() -> Blocks.f_50092_).blockstate(this::buildVineModel).loot(this::buildVineLoot).tag(new TagKey[]{BlockTags.f_13082_}).register();
        this.side = YoukaisHomecoming.REGISTRATE.block(name + "_branches", x$0 -> new GrapeBranch((BlockBehaviour.Properties)x$0)).initialProperties(() -> Blocks.f_50092_).blockstate(this::buildBranchModel).loot(this::buildVineLoot).tag(new TagKey[]{BlockTags.f_13082_}).register();
        this.hanging = YoukaisHomecoming.REGISTRATE.block(name + "_fruits", x$0 -> new GrapeFruit((BlockBehaviour.Properties)x$0)).properties(p -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY)).blockstate(this::buildFruitModel).loot(this::buildFruitLoot).register();
    }

    public static void buildPlantModel(DataGenContext<Block, GrapeCropBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        String[] strs = name.split("_");
        String col = strs[0];
        String type = strs[1];
        int start = ((GrapeCropBlock)((Object)ctx.get())).getDoubleBlockStart();
        BlockModelBuilder empty = (BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent("small_" + name + "_upper_empty", pvd.mcLoc("block/air"))).texture("particle", pvd.modLoc("block/plants/" + type + "/small/upper" + start));
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)GrapeCropBlock.AGE);
            boolean rope = (Boolean)state.m_61143_((Property)RopeLoggedCropBlock.ROPELOGGED);
            boolean root = (Boolean)state.m_61143_((Property)DoubleRopeCropBlock.ROOT);
            if (!root && age < start) {
                return ConfiguredModel.builder().modelFile((ModelFile)empty).build();
            }
            String tag = (root ? "lower" : "upper") + age;
            String tex = "block/plants/" + type + "/small/" + tag;
            if (age == ((GrapeCropBlock)((Object)((Object)ctx.get()))).m_7419_()) {
                tex = tex + "_" + col;
            }
            if (rope) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("small_rope_" + name + "_" + tag)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/rope_crop")))).texture("cross", tex)).texture("rope_side", pvd.modLoc("block/plants/rope"))).texture("rope_top", pvd.modLoc("block/plants/rope_top"))).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("small_bare_" + name + "_" + tag)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/rope_crop_bare")))).texture("cross", tex)).renderType("cutout")).build();
        });
    }

    public static void buildPlantLoot(RegistrateBlockLootTables pvd, GrapeCropBlock block, YHCrops crop) {
        pvd.m_247577_((Block)block, (LootTable.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)crop.getSeed())).m_79080_(LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)block.m_7959_(), block.m_7419_())).m_81807_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)DoubleRopeCropBlock.ROOT, true)))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)block.m_7959_(), block.m_7419_()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)crop.getFruits()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)DoubleRopeCropBlock.ROOT, true))))));
    }

    protected void buildTrunkLoot(RegistrateBlockLootTables pvd, VineTrunkBlock block) {
        pvd.m_247577_((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block.seed)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_))));
    }

    protected void buildVineLoot(RegistrateBlockLootTables pvd, BaseCropVineBlock block) {
        pvd.m_247577_((Block)block, (LootTable.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)block.getAgeProperty(), block.getMaxAge()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)this.crop.getFruits()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))))));
    }

    protected void buildFruitLoot(RegistrateBlockLootTables pvd, VineFruitBlock block) {
        pvd.m_247577_((Block)block, (LootTable.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)block.getAgeProperty(), block.getMaxAge()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)this.crop.getFruits()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))))));
    }

    protected void buildTrunkModel(DataGenContext<Block, GrapeTrunk> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.crop.getName();
        String type = this.crop.getTypeName();
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            boolean merged = (Boolean)state.m_61143_((Property)GrapeTrunk.MERGED);
            if (merged) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("tree_" + name + "_trunk")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/plant/grape_trunk")))).texture("cross", "block/plants/" + type + "/trunk_cross")).texture("post", "block/plants/" + type + "/trunk_post")).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("tree_" + name + "_trunk_rope")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/rope_crop")))).texture("cross", "block/plants/" + type + "/trunk_cross")).texture("rope_side", pvd.modLoc("block/plants/rope"))).texture("rope_top", pvd.modLoc("block/plants/rope_top"))).renderType("cutout")).build();
        });
    }

    protected void buildVineModel(DataGenContext<Block, GrapeVine> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.crop.getName();
        String[] strs = name.split("_");
        String col = strs[0];
        String type = strs[1];
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.getVine((BlockState)state, name, type, col, "vine", (DataGenContext<Block, ? extends BaseCropVineBlock>)ctx, pvd)).rotationY(state.m_61143_(CenterCropVineBlock.AXIS) == Direction.Axis.X ? 0 : 90).build());
    }

    protected void buildBranchModel(DataGenContext<Block, GrapeBranch> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.crop.getName();
        String[] strs = name.split("_");
        String col = strs[0];
        String type = strs[1];
        pvd.horizontalBlock((Block)ctx.get(), state -> this.getVine((BlockState)state, name, type, col, "branch", (DataGenContext<Block, ? extends BaseCropVineBlock>)ctx, pvd), -90);
    }

    protected BlockModelBuilder getVine(BlockState state, String name, String type, String col, String folder, DataGenContext<Block, ? extends BaseCropVineBlock> ctx, RegistrateBlockstateProvider pvd) {
        BlockModelBuilder builder;
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean top = (Boolean)state.m_61143_((Property)BaseCropVineBlock.TOP);
        Object suffix = "";
        if (age == ((BaseCropVineBlock)((Object)ctx.get())).getMaxAge()) {
            suffix = "_" + col;
        }
        String set = top ? "top" : folder;
        String coil = "block/plants/" + type + "/" + set + "/coil" + age + (String)suffix;
        String vine = "block/plants/" + type + "/" + set + "/vine" + age + (String)suffix;
        String leaves = "block/plants/" + type + "/leaves/leaves" + age + (String)suffix;
        String model = "tree_" + name + "_" + folder + age;
        if (ctx.get() instanceof BranchCropVineBlock) {
            boolean ext = (Boolean)state.m_61143_((Property)BranchCropVineBlock.EXTENDED);
            builder = (BlockModelBuilder)pvd.models().getBuilder(model + (top ? "_top" : "") + (ext ? "_extended" : ""));
            builder.texture("vine", pvd.modLoc(ext ? coil : vine));
        } else {
            boolean l = (Boolean)state.m_61143_((Property)CenterCropVineBlock.LEFT);
            boolean r = (Boolean)state.m_61143_((Property)CenterCropVineBlock.RIGHT);
            builder = (BlockModelBuilder)pvd.models().getBuilder(model + (l ? "l" : "") + (r ? "r" : "") + (top ? "_top" : ""));
            ((BlockModelBuilder)builder.texture("coil_left", pvd.modLoc(l ? coil : vine))).texture("coil_right", pvd.modLoc(r ? coil : vine));
        }
        if (top) {
            builder.parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/plant/grape_" + folder + "_top")));
            builder.texture("leaves", pvd.modLoc(leaves));
        } else if (age >= 5) {
            String bottom = "block/plants/" + type + "/" + folder + "/bottom" + age + (String)suffix;
            builder.parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/plant/grape_" + folder + "_mature")));
            builder.texture("bottom", pvd.modLoc(bottom));
            builder.texture("leaves", pvd.modLoc(leaves));
        } else {
            builder.parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/plant/grape_" + folder)));
        }
        ((BlockModelBuilder)((BlockModelBuilder)builder.texture("coil", pvd.modLoc(coil))).texture("rope_top", pvd.modLoc("block/plants/rope_top"))).renderType("cutout");
        return builder;
    }

    protected void buildFruitModel(DataGenContext<Block, GrapeFruit> ctx, RegistrateBlockstateProvider pvd) {
        String name = this.crop.getName();
        String[] strs = name.split("_");
        String col = strs[0];
        String type = strs[1];
        pvd.horizontalBlock((Block)ctx.get(), state -> {
            int age = (Integer)state.m_61143_((Property)FRUIT_AGE);
            Object suffix = "";
            if (age == ((GrapeFruit)((Object)((Object)ctx.get()))).getMaxAge()) {
                suffix = "_" + col;
            }
            String fruit = "block/plants/" + type + "/fruit/fruit" + age + (String)suffix;
            String bottom = "block/plants/" + type + "/branch/bottom" + age + (String)suffix;
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("tree_" + name + "_fruit" + age)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/plant/grape_fruit")))).texture("fruit", pvd.modLoc(fruit))).texture("bottom", pvd.modLoc(bottom))).renderType("cutout");
        }, -90);
    }

    public static BlockEntry<? extends Block> wildBush(YHCrops crop) {
        BlockBuilder builder = crop.getName().equals("black_grape") ? YoukaisHomecoming.REGISTRATE.block("wild_" + crop.getName(), WildVineBlock::new).properties(p -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_154664_).m_278166_(PushReaction.DESTROY)).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends Block>)ctx, pvd, crop)) : YoukaisHomecoming.REGISTRATE.block("wild_" + crop.getName(), BushBlock::new).initialProperties(() -> Blocks.f_50111_).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/" + ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/large_cross_bush")))).texture("cross", pvd.modLoc("block/plants/" + crop.getTypeName() + "/" + ctx.getName() + "_bush"))).renderType("cutout")));
        return ((BlockBuilder)builder.item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/plants/" + crop.getTypeName() + "/" + ctx.getName())})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).loot((ctx, pvd) -> PlantJsonGen.wildDropFruit(ctx, pvd, crop)).register();
    }

    public class GrapeFruit
    extends VineFruitBlock {
        public static final VoxelShape SMALL = GrapeFruit.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        public static final VoxelShape SHAPE = GrapeFruit.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

        public GrapeFruit(BlockBehaviour.Properties prop) {
            super(prop);
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FRUIT_AGE, (Comparable)Integer.valueOf(5)));
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
            return (Integer)state.m_61143_((Property)this.getAgeProperty()) == 5 ? SMALL : SHAPE;
        }

        @Override
        protected ItemLike getFruit(BlockState state) {
            return GrapeVineSet.this.crop.getFruits();
        }

        @Override
        protected BranchCropVineBlock getHanger() {
            return (BranchCropVineBlock)((Object)GrapeVineSet.this.side.get());
        }

        @Override
        protected IntegerProperty getAgeProperty() {
            return FRUIT_AGE;
        }

        @Override
        public int getMaxAge() {
            return 9;
        }

        @Override
        protected int getBaseAge() {
            return 6;
        }
    }

    public class GrapeTrunk
    extends VineTrunkBlock {
        public GrapeTrunk(BlockBehaviour.Properties prop, ItemLike clone) {
            super(prop, clone);
        }

        @Override
        protected CenterCropVineBlock getTop() {
            return (CenterCropVineBlock)((Object)GrapeVineSet.this.center.get());
        }
    }

    public class GrapeBranch
    extends BranchCropVineBlock {
        public static final VoxelShape[] SMALL = new VoxelShape[4];
        public static final VoxelShape[] LARGE = new VoxelShape[4];

        public GrapeBranch(BlockBehaviour.Properties prop) {
            super(prop);
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
            return ((Integer)state.m_61143_((Property)this.getAgeProperty()) >= 5 || (Boolean)state.m_61143_((Property)TOP) != false ? LARGE : SMALL)[((Direction)state.m_61143_((Property)FACING)).m_122416_()];
        }

        @Override
        protected CenterCropVineBlock getCenter() {
            return (CenterCropVineBlock)((Object)GrapeVineSet.this.center.get());
        }

        @Override
        @Nullable
        protected VineFruitBlock getHanging() {
            return (VineFruitBlock)((Object)GrapeVineSet.this.hanging.get());
        }

        @Override
        public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
            return GrapeVineSet.this.crop.getSeed().m_7968_();
        }

        @Override
        protected ItemLike getFruit() {
            return GrapeVineSet.this.crop.getFruits();
        }

        @Override
        protected IntegerProperty getAgeProperty() {
            return AGE;
        }

        @Override
        public int getMaxAge() {
            return 9;
        }

        @Override
        protected int getBaseAge() {
            return 6;
        }

        @Override
        protected int getFruitChance() {
            return 5;
        }

        static {
            for (int i = 0; i < 4; ++i) {
                GrapeBranch.SMALL[i] = new VoxelBuilder(7, 0, 0, 9, 16, 16).rotateFromNorth(Direction.m_122407_((int)i));
                GrapeBranch.LARGE[i] = new VoxelBuilder(4, 0, 0, 12, 16, 16).rotateFromNorth(Direction.m_122407_((int)i));
            }
        }
    }

    public class GrapeVine
    extends CenterCropVineBlock {
        public static final VoxelShape SMALL_X = GrapeVine.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        public static final VoxelShape SMALL_Z = GrapeVine.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        public static final VoxelShape LARGE_X = GrapeVine.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
        public static final VoxelShape LARGE_Z = GrapeVine.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);

        public GrapeVine(BlockBehaviour.Properties prop) {
            super(prop);
        }

        public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
            return state.m_61143_((Property)AXIS) == Direction.Axis.X ? ((Integer)state.m_61143_((Property)this.getAgeProperty()) >= 5 ? LARGE_X : SMALL_X) : ((Integer)state.m_61143_((Property)this.getAgeProperty()) >= 5 ? LARGE_Z : SMALL_Z);
        }

        @Override
        protected VineTrunkBlock getTrunk() {
            return (VineTrunkBlock)((Object)GrapeVineSet.this.trunk.get());
        }

        @Override
        protected BranchCropVineBlock getSide() {
            return (BranchCropVineBlock)((Object)GrapeVineSet.this.side.get());
        }

        @Override
        protected ItemLike getFruit() {
            return GrapeVineSet.this.crop.getFruits();
        }

        @Override
        public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
            return GrapeVineSet.this.crop.getSeed().m_7968_();
        }

        @Override
        protected IntegerProperty getAgeProperty() {
            return AGE;
        }

        @Override
        public int getMaxAge() {
            return 9;
        }

        @Override
        protected int getBaseAge() {
            return 6;
        }
    }
}

